﻿#target photoshop-10
// (c) Copyright 2007.  Adobe Systems, Incorporated.  All rights reserved.
/*
@@@BUILDINFO@@@ photoshop-10.jsx 1.0.0.14  18-Jan-2007
*/


/*
@@@START_XML@@@
<?xml version="1.0" encoding="UTF-8"?>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="en_US">
     <dc:title>Adobe Photoshop CS3</dc:title>
     <dc:description>This script enables other applications to communicate with Adobe Photoshop CS3.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="fr_FR">
     <dc:title>Adobe Photoshop CS3</dc:title>
     <dc:description>Ce script permet à d'autres applications de communiquer avec Adobe Photoshop CS3.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="ja_JP">
     <dc:title>Adobe Photoshop CS3</dc:title>
     <dc:description>このスクリプトは、他のアプリケーションと Adobe Photoshop CS3 との通信を有効にします。</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="de_DE">
     <dc:title>Adobe Photoshop CS3</dc:title>
     <dc:description>Mithilfe dieses Skripts können andere Anwendungen mit Adobe Photoshop CS3 kommunizieren.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="it_IT">
     <dc:title>Adobe Photoshop CS3</dc:title>
     <dc:description>Questo script consente ad altre applicazioni di comunicare con Adobe Photoshop CS3</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="es_ES">
     <dc:title>Adobe Photoshop CS3</dc:title>
     <dc:description>Este script posibilita que otras aplicaciones se comuniquen con Adobe Photoshop CS3</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="nl_NL">
     <dc:title>Adobe Photoshop CS3</dc:title>
     <dc:description>Dit script laat andere toepassingen toe te communiceren met Adobe Photoshop CS3</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="pt_BR">
     <dc:title>Adobe Photoshop CS3</dc:title>
     <dc:description>Este script permite que outros aplicativos se comuniquem com o Adobe Photoshop CS3</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="nb_NO">
     <dc:title>Adobe Photoshop CS3</dc:title>
     <dc:description>Skriptet gjør at andre programmer kan kommunisere med Adobe Photoshop CS3</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="da_DA">
     <dc:title>Adobe Photoshop CS3</dc:title>
     <dc:description>Dette script betyder, at andre programmer kan kommunikere med Adobe Photoshop CS3</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="fi_FI">
     <dc:title>Adobe Photoshop CS3</dc:title>
     <dc:description>Tämän komentosarjan avulla muut sovellukset ja Adobe Photoshop CS3 voivat kommunikoida keskenään</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="se_SE">
     <dc:title>Adobe Photoshop CS3</dc:title>
     <dc:description>Det här skriptet gör det möjligt för andra program att kommunicera med Adobe Photoshop CS3</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="zh_TW">
     <dc:title>Adobe Photoshop CS3</dc:title>
     <dc:description>"此指令碼能讓其他應用程式與 Adobe Photoshop CS3 進行通訊。</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="zh_CN">
     <dc:title>Adobe Photoshop CS3</dc:title>
     <dc:description>"此脚本使其它应用程序能够与 Adobe Photoshop CS3 进行通信</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="ko_KO">
     <dc:title>Adobe Photoshop CS3</dc:title>
     <dc:description>"이 스크립트를 사용하면 다른 응용 프로그램에서 Adobe Photoshop CS3과(와) 통신할 수 있습니다.</dc:description>
</ScriptInfo>
@@@END_XML@@@
*/





// This JavaScript is to be read by Bridge, Photoshop, and other Adobe apps at
// launch. It enables some Photoshop-Bridge integration, such as installing
// the Photoshop automate commands in the Bridge menus, and generally exposes
// a larger Photoshop dom to the other apps.

// debug level: 0-2 (0:disable, 1:break on error, 2:break at beginning)
$.level = 0;
// debugger; // launch debugger on next line

// on localized builds we pull the $$$/Strings from a .dat file
$.localize = true;


//=================================================================
// Setup/Support
// This first portion of the script sets up an object to provide
// scope for all Photoshop BridgeTalk related routines to prevent
// name collision with other groups' scripts, defines some common
// utility functions, and adds some Photoshop related commands
// to the Bridge menus.
//=================================================================


try
{ // Overall try catch


//-----------------------------------------------------------------
// A Note About Exception Handling
//-----------------------------------------------------------------
// If execution of the body of a BridgeTalk message throws an
// exception, it will be silently swept under the carpet and not
// reported to the user. Therefore, many of the functions in here
// which are run as the body of a BridgeTalk message due to a user
// request have an overall try-catch to report such errors.
//
// Exceptions thrown out of Bridge MenuElement onSelect methods are
// also not reported, so they are wrapped in try-catch statements
// here.
//
// The X-DOM functions are not wrapped in try-catch statements so
// it is up to the caller to handle any exceptions if calling X-DOM
// functions via BridgeTalk.
//-----------------------------------------------------------------




// ================================================================
// ================================================================
// ================================================================
// Setup/Initialization
// The code below does basic initialization and setup tasks and
// must appear at the beggining of this script.
// ================================================================
// ================================================================
// ================================================================



try
{ // Inner try-catch to handle version info object disposal

var tempPSVersionInfo = new Object;
tempPSVersionInfo.scriptRevision = 11;
tempPSVersionInfo.btTargetName = 'photoshop-10.0';
tempPSVersionInfo.majorVersion = 10;
tempPSVersionInfo.minorVersion = 0;
tempPSVersionInfo.version = tempPSVersionInfo.majorVersion + '.' + tempPSVersionInfo.minorVersion;
tempPSVersionInfo.displayVersion = localize ("$$$/PSBI/CS3=CS3");
tempPSVersionInfo.bridgeTargetVersion = 2;
tempPSVersionInfo.bridgeTarget = 'bridge-' + tempPSVersionInfo.bridgeTargetVersion;
tempPSVersionInfo.bridgeDisplayVersion = localize ("$$$/PSBI/CS3=CS3");


//-----------------------------------------------------------------
// Guard against loading script if matching version of PS is not
// installed.
//-----------------------------------------------------------------

// getTargets (0) returns all versions of all apps - see if this version is among them
if (BridgeTalk.getTargets (0).join ().indexOf (tempPSVersionInfo.btTargetName) == -1)
	{
	if ((BridgeTalk.appName == "photoshop") && (BridgeTalk.appVersion == tempPSVersionInfo.version))
		{
		// Something is wrong! BridgeTalk thinks this version of Photoshop is not installed, but it is running this script...
		// Allow the script to load so that the user does not get bizarre JavaScript errors about photoshop not being defined,
		// and can still Browse to Bridge from Photoshop if the Bridge installation is not damaged. Hopefully the app(s) will
		// be able to self-heal the problem after a relaunch.
		}
	else
		throw localize ("$$$/PSBI/Error/MatchingPSVersionNotInstalled=The version of Photoshop matching this script (%1) is not installed or its installation is damaged. Please reinstall.", tempPSVersionInfo.version);
	}
	
//-----------------------------------------------------------------
// Guard against loading multiple revisions of the same startup
// script. The latest revision will take precedence.
//-----------------------------------------------------------------

if (typeof photoshop10 != "undefined")
	{
	if ((photoshop10.versionInfo.scriptRevision == undefined) ||
		(photoshop10.versionInfo.scriptRevision < tempPSVersionInfo.scriptRevision))
		delete photoshop10;
	else
		// Bail out right here.
		throw localize ("$$$/PSBI/Error/PSObjectDefined=Object photoshop10 has already been defined. Older revision ignored.");
	}

}
catch (e)
{
	delete tempPSVersionInfo;
	throw e;
}


//-----------------------------------------------------------------
// Define photoshop10 object.
//-----------------------------------------------------------------

var photoshop10 = new Object;
photoshop10.versionInfo = tempPSVersionInfo;
delete tempPSVersionInfo;


// Set the generic photoshop object equal to photoshop10 if that is
// the highest installed version on this machine.
// getTargets (null) returns the highest version of each app - see if this version is among them
if (BridgeTalk.getTargets (null).join ().indexOf (photoshop10.versionInfo.btTargetName) != -1)
	photoshop = photoshop10;
	
//-----------------------------------------------------------------
// Throughout this script commands are set up to be added to the
// Tools > Photoshop menu in Bridge. Since Bridge's menu API does
// not support automatic alphabetizing of menu items, we create
// an array with all the necessary menu item info in it, then sort
// it at the end of this script and create all the menu items.
//-----------------------------------------------------------------
photoshop10.menuItemInfoArray = new Array ();



//-----------------------------------------------------------------
// An object used to control how UI is used and what behavior is
// chosen when checking to see if the correct version of PS is
// available to run a command.
//-----------------------------------------------------------------
AvailabilityCheckOptions.kBusyAsk = 0;
AvailabilityCheckOptions.kBusyWarn = 1;
AvailabilityCheckOptions.kBusyAutoQueue = 2;
AvailabilityCheckOptions.kBusyAutoCancel = 3;

function AvailabilityCheckOptions (inBusyAction, inWarnIfUnavailable)
	{
	// control how a busy PS is handled	
	this.busyAction = (inBusyAction == null) ? AvailabilityCheckOptions.kBusyAsk : inBusyAction;
	this.warnBusyText = localize ("$$$/PSBI/Error/PSBusyWarn=Photoshop %1 is currently busy with another task. Please finish that task in Photoshop and try again.", photoshop10.versionInfo.displayVersion);
	this.askBusyText = localize ("$$$/PSBI/Error/PSBusyAsk=Photoshop %1 is currently busy with another task. Would you like to queue this command?", photoshop10.versionInfo.displayVersion);
	
	// control how an uninstalled version of PS is controlled
	this.warnIfUnavailable = (inWarnIfUnavailable == null) ? true : inWarnIfUnavailable;
	this.warnInsidePSText = localize ("$$$/PSBI/Error/OtherVersionRunningInPS=Photoshop %1 is required for this command. Please quit this version and try again.", photoshop10.versionInfo.displayVersion);

	// used to prevent UI from being shown twice in same call stack;
	// this gets set and the return value is remembered
	this.alreadyUsed = false;
	this.alreadyUsedReturnValue = false;
	}
	
// ================================================================
// ================================================================
// ================================================================
// CrossDOM/X-DOM
// Implements Photoshop's cross DOM API - the a small set of
// operations that are common to all Adobe apps.
// ================================================================
// ================================================================
// ================================================================

//-----------------------------------------------------------------
// executeScript (script) - Performs an "eval" on the given script.
//
// return value		Object		The value of evaling the last line
//								of the script
// script			String		The script to be evaled
//-----------------------------------------------------------------

photoshop10.executeScript = function (script, availabilityCheckOptions)
	{
	// Make sure this can be run.
	if (availabilityCheckOptions == null)
		availabilityCheckOptions = new AvailabilityCheckOptions ();
		
	if (!photoshop10.correctPSIsAvailable (availabilityCheckOptions))
		return;
		
	if (BridgeTalk.appName != "photoshop")
		{
		// Bring Photoshop to the foreground.
		BridgeTalk.bringToFront (photoshop10.versionInfo.btTargetName);
		
		// Create a new BridgeTalk message for Photoshop to invoke
		// executeScript.
		var btMessage = new BridgeTalk;
		btMessage.target = photoshop10.versionInfo.btTargetName;
		btMessage.body = "photoshop10.executeScript (" + script.toSource () + ");";
		btMessage.send();
		}
	else
		{
		// This is Photoshop, so just call our DOM routine
		eval (script);
		}
	}

//-----------------------------------------------------------------
// open (files) - Performs the equivalent of File->Open on the
// requested paths. Accepts either an Array object or a single
// path.
//
// return value 	Array of File			an array of all the
//											successfully opened
//											files
// files			File or Array of File	files to open
//-----------------------------------------------------------------

photoshop10.open = function (files, availabilityCheckOptions)
	{
	// Make sure this can be run.
	if (availabilityCheckOptions == null)
		availabilityCheckOptions = new AvailabilityCheckOptions ();
		
	if (!photoshop10.correctPSIsAvailable (availabilityCheckOptions))
		return;
		
	if (BridgeTalk.appName != "photoshop")
		{
		// Bring Photoshop to the foreground.
		BridgeTalk.bringToFront (photoshop10.versionInfo.btTargetName);
		
		// Create a new BridgeTalk message for Photoshop to invoke
		// open.
		var btMessage = new BridgeTalk;
		btMessage.target = photoshop10.versionInfo.btTargetName;
		btMessage.body = "photoshop10.open (" + files.toSource () + ");";
		btMessage.send();
		}
	else
		{
		// This is Photoshop, so just call our DOM routine with the files		
		var fileArray = photoshop10.ExtractFileArray (files); 
		
		for (index = 0; index < fileArray.length; ++index)
			{
			var file = fileArray[index];
			
			app.open (file);
			}
		}
	}

//-----------------------------------------------------------------
// openAsNew ([creation-options]*) - Performs the equivalent of
// File->New. The creation-options are app-specific and should
// ideally map on to the app's new() function. PS has no creation
// options.
//
// return value		Boolean		true if successful
//-----------------------------------------------------------------

photoshop10.openAsNew = function (availabilityCheckOptions)
	{
	// Make sure this can be run.
	if (availabilityCheckOptions == null)
		availabilityCheckOptions = new AvailabilityCheckOptions ();
		
	if (!photoshop10.correctPSIsAvailable (availabilityCheckOptions))
		return;
		
	if (BridgeTalk.appName != "photoshop")
		{
		// Bring Photoshop to the foreground.
		BridgeTalk.bringToFront (photoshop10.versionInfo.btTargetName);
		
		// Create a new BridgeTalk message for Photoshop to invoke
		// open.
		var btMessage = new BridgeTalk;
		btMessage.target = photoshop10.versionInfo.btTargetName;
		btMessage.body = "photoshop10.openAsNew ();";
		btMessage.send();
		}
	else
		{
		// This is Photoshop, so just call our DOM routine
		app.documents.add ();
		}
	}

//-----------------------------------------------------------------
// print (files) - Performs the equivalent of File->Print on the
// requested files.
//
// return value			Array of File			the array of files
//												successfully
//												printed
// files				File or Array of File	files to be printed
//-----------------------------------------------------------------

photoshop10.print = function (files, availabilityCheckOptions)
	{
	// Make sure this can be run.
	if (availabilityCheckOptions == null)
		availabilityCheckOptions = new AvailabilityCheckOptions ();
		
	if (!photoshop10.correctPSIsAvailable (availabilityCheckOptions))
		return;
		
	if (BridgeTalk.appName != "photoshop")
		{
		// Bring Photoshop to the foreground.
		BridgeTalk.bringToFront (photoshop10.versionInfo.btTargetName);
		
		// Create a new BridgeTalk message for Photoshop to invoke
		// open.
		var btMessage = new BridgeTalk;
		btMessage.target = photoshop10.versionInfo.btTargetName;
		btMessage.body = "photoshop10.print (" + files.toSource () + ");";
		btMessage.send();
		}
	else
		{
		// This is Photoshop, so just call our DOM routine with the files		
		var fileArray = photoshop10.ExtractFileArray (files); 
		
		for (index = 0; index < fileArray.length; ++index)
			{
			var file = fileArray[index];
			
			var document = app.open (file);
			
			if (document != undefined)
				{
				var rememberDialogModes = displayDialogs;
				displayDialogs = DialogModes.ALL;
				document.print ();
				displayDialogs = rememberDialogModes;
				}
			}
		}
	}

//-----------------------------------------------------------------
// quit () - Performs the equivalent of File->Exit or File->Close.
//
//	return value	undefined
//-----------------------------------------------------------------

photoshop10.quit = function (availabilityCheckOptions)
	{
	// Make sure this can be run.
	if (availabilityCheckOptions == null)
		availabilityCheckOptions = new AvailabilityCheckOptions (AvailabilityCheckOptions.kBusyWarn, false); // warn if busy, don't warn if wrong version is running
		
	if (!photoshop10.correctPSIsAvailable (availabilityCheckOptions))
		return;
		
	if (BridgeTalk.appName != "photoshop")
		{
		// Bring Photoshop to the foreground.
		BridgeTalk.bringToFront (photoshop10.versionInfo.btTargetName);
		
		// Create a new BridgeTalk message for Photoshop to invoke
		// open.
		var btMessage = new BridgeTalk;
		btMessage.target = photoshop10.versionInfo.btTargetName;
		btMessage.body = "photoshop10.quit ();";
		btMessage.send();
		}
	else
		{
		// This is Photoshop, so just call our DOM		
		var quitID = stringIDToTypeID ('quit');
		executeAction (quitID, undefined, DialogModes.NO);
		}
	}

//-----------------------------------------------------------------
// reveal (file) - Gives the target app focus and brings the
// specified document to the foreground if it is already open.
//
// return value		Boolean		true if the file was open and was
//								successfully brought to the
//								foreground
// file				File		file to be revealed
//-----------------------------------------------------------------

photoshop10.reveal = function (file, availabilityCheckOptions)
	{
	// Make sure this can be run.
	if (availabilityCheckOptions == null)
		availabilityCheckOptions = new AvailabilityCheckOptions ();
		
	if (!photoshop10.correctPSIsAvailable (availabilityCheckOptions))
		return;
		
	if (BridgeTalk.appName != "photoshop")
		{
		// Bring Photoshop to the foreground.
		BridgeTalk.bringToFront (photoshop10.versionInfo.btTargetName);
		
		// Create a new BridgeTalk message for Photoshop to invoke
		// open.
		var btMessage = new BridgeTalk;
		btMessage.target = photoshop10.versionInfo.btTargetName;
		btMessage.body = "photoshop10.reveal (" + file.toSource () + ");";
		btMessage.send();
		}
	else
		{
		// This is Photoshop, so just call our DOM routine with the files		
		// Loop through the open documents looking for the one
		// we want to reveal. If it is found, make it the active
		// document.
		var docNum = app.documents.length - 1;
		
		while (docNum >= 0)
			{
			var document = app.documents[docNum];
			
			// If document is a new unsaved document, accessing
			// document.fullName results in an error. Comparing
			// it to undefined also results in an error, so it
			// is in a try-catch instead.
			try
				{
				if (document.fullName.fsName == file.fsName)
					{
					app.activeDocument = document;
					break;
					}
				}
			catch (e)
				{
				// ignore.
				}
				
			--docNum;
			}
		}
	}
	
	

// ================================================================
// ================================================================
// ================================================================
// Photoshop Commands
// The code below is for functionality which is present in
// Photoshop, such as Browse...
// ================================================================
// ================================================================
// ================================================================


//=================================================================
// Invoking Bridge
// Is called by Photoshop to invoke Bridge.
//=================================================================

photoshop10.invokeBridge = function (newWindow, maximize, path)
	{
	// Make sure this can be run, otherwise alert the user (true for UI).
	if (!photoshop10.correctBridgeIsAvailable (true))
		return;
		
	if (BridgeTalk.isRunning (photoshop10.versionInfo.bridgeTarget))
		{
		// Bring Bridge to the foreground.
		BridgeTalk.bringToFront (photoshop10.versionInfo.bridgeTarget);
		}
	else
		{
		// Make sure we attempt to launch it.
		BridgeTalk.launch (photoshop10.versionInfo.bridgeTarget);
		}
	
	// Send an appropriate message to Bridge to tell it what to do.
	var bt = photoshop10.getInvokeBridgeMessage (newWindow, maximize, path);
	
	bt.send ();
	}

//=================================================================
// Launching Bridge
// Is called by Photoshop to launch Bridge in the background at
// startup.
//=================================================================

photoshop10.launchBridgeInBackground = function ()
	{
	// Make sure this can be run, don't alert the user if it can't (false for no UI).
	if (!photoshop10.correctBridgeIsAvailable (false))
		return;
		
	if (!BridgeTalk.isRunning (photoshop10.versionInfo.bridgeTarget))
		{
		BridgeTalk.launch (photoshop10.versionInfo.bridgeTarget, 'background');
			
		// On Mac we are able to effectively launch Bridge without Photoshop
		// losing focus, so all we have to do is launch Bridge. On Windows we
		// are not so lucky and must employ some trickery to avoid having
		// Bridge take over as the active app.
		if ($.os.charAt (0) == 'M')
			return;
		
		
		// Win trickery
		
		// Get the version number of Bridge so we can locate its
		// app/user specific startup directory.
		var bridgeSpecifier = BridgeTalk.getSpecifier("bridge", photoshop10.versionInfo.bridgeTargetVersion);
		var bridgeVersion = null;
		
		if (bridgeSpecifier != null)
			bridgeVersion = bridgeSpecifier.match (/[0-9\.]+/);
		
		// Define a function that will be run inside of Bridge to make
		// Photoshop come to the foreground. This script will be
		// written to a temporary startup script and will self-delete
		// after run.
		var launchBridgeBehindScript = function (bridgeVersion)
			{
			// On Windows, bringToFront is only effective if the calling app is
			// the foreground app, so it can't be called until Bridge has created
			// a window. So if necessary, we insert a handler function that
			// deletes itself after one execution.
			if (app.documents.length > 0)
				{
				// the document has already been created, so just bring PS to the foreground.
				BridgeTalk.bringToFront (photoshop10.versionInfo.btTargetName);
				return;
				}
			
			// define the handler
			var bringPSForwardOnceHandler = function (event)
				{
				// Run on document creation.
				if (event.object.constructor.name == 'Document' && event.type == 'create')
					{
					// Bring Photoshop to the foreground.
					BridgeTalk.bringToFront (photoshop10.versionInfo.btTargetName);
	
					// Remove this handler once it has run.
					for (var index = 0; index < app.eventHandlers.length; index++)
						{
						if (app.eventHandlers[index] == this)
							{
							app.eventHandlers[index] = null;
							break;
							}
						}
					}
				
				 // Return false so Bridge will keep calling other event handlers.
				return { handled: false };
				}
			
			// Install the event handler.
			app.eventHandlers.push ({handler: bringPSForwardOnceHandler});
			
			} // launchBridgeBehindScript

		
		// Send the script defined above to Bridge for it to execute.
		var bt = new BridgeTalk;
		bt.target = photoshop10.versionInfo.bridgeTarget;
		bt.body = 'var func = ' + launchBridgeBehindScript.toString () + 'func ("' + bridgeVersion + '");';
		bt.send ();
	
		} // !BridgeTalk.isRunning (photoshop10.versionInfo.bridgeTarget)
	}


// ================================================================
// ================================================================
// ================================================================
// Bridge Commands
// The code below is for functionality which is present in Bridge,
// such as the automation commands and File > Place > In Photoshop.
// ================================================================
// ================================================================
// ================================================================


//=================================================================
// Place
// Sets up Place in Photoshop command in Bridge's Place menu.
//=================================================================

//-----------------------------------------------------------------
// Performs the equivalent of the File->Place
// command on the requested file.
//-----------------------------------------------------------------

photoshop10.place = function (file, availabilityCheckOptions)
	{
	try
		{
		// Make sure this can be run.
		if (availabilityCheckOptions == null)
			availabilityCheckOptions = new AvailabilityCheckOptions ();
		
		// customize the behavior
		availabilityCheckOptions.busyAction = AvailabilityCheckOptions.kBusyWarn;
		availabilityCheckOptions.warnBusyText = localize ("$$$/PSBI/Error/PSBusyWarnPlace=Photoshop %1 is currently busy with another task. Please finish that task in Photoshop, open the document you want to place into, and try again.", photoshop10.versionInfo.displayVersion);
		
		if (!photoshop10.correctPSIsAvailable (availabilityCheckOptions))
			return;
			
		if (BridgeTalk.appName != "photoshop")
			{
			// Bring Photoshop to the foreground.
			BridgeTalk.bringToFront (photoshop10.versionInfo.btTargetName);
			
			// Create a new BridgeTalk message for Photoshop to invoke
			// open.
			var btMessage = new BridgeTalk;
			btMessage.target = photoshop10.versionInfo.btTargetName;
			btMessage.body = "photoshop10.place (" + file.toSource () + ");";
			
			
			// Make sure we attempt to launch it.
			if (!BridgeTalk.isRunning (photoshop10.versionInfo.btTargetName))
				BridgeTalk.launch (photoshop10.versionInfo.btTargetName);
			
			btMessage.send();
			}
		else
			{
			var fileArray = photoshop10.ExtractFileArray (file);
				
			// This is Photoshop, so just call our DOM routine with the files		
			if (app.documents.length > 0)
				{
				if (fileArray.length > 0)
					{
					var theFile = fileArray[0];
					
					// Set up generic placement information.
					var offsetID = stringIDToTypeID ('offset');
					var horizID = stringIDToTypeID ('horizontal');
					var vertID = stringIDToTypeID ('vertical');
					var distUnitID = stringIDToTypeID ('distanceUnit');
					
					var offsetDesc = new ActionDescriptor ();
					
					offsetDesc.putUnitDouble (horizID, distUnitID, 0.000000);
					offsetDesc.putUnitDouble (vertID, distUnitID, 0.000000);
					
					var nullID = charIDToTypeID ('null');
					var ftcenterID = stringIDToTypeID ('freeTransformCenterState');
					var quadCenterID = stringIDToTypeID ('quadCenterState');
					var avgID = stringIDToTypeID ('QCSAverage');
					
					var placeInfoDesc = new ActionDescriptor ();
					
					placeInfoDesc.putEnumerated (ftcenterID, quadCenterID, avgID);
					placeInfoDesc.putObject (offsetID, offsetID, offsetDesc);
					
					// Set up the file.
					placeInfoDesc.putPath (nullID, theFile);
					
					// Suppress choose file dialog.
					var overrideOpenID = stringIDToTypeID ('overrideOpen');
					placeInfoDesc.putBoolean (overrideOpenID, true);
					
					// Force it to record.
					var forceRecordKey = stringIDToTypeID ('forceRecording');
					placeInfoDesc.putBoolean (forceRecordKey, true);
					
					// Do the Place.
					var placeID = stringIDToTypeID ('placeEvent');
					
					executeAction (placeID, placeInfoDesc, DialogModes.ALL);
					
					// force deletion of ActionDescriptor now
					offsetDesc = null;
					placeInfoDesc = null;
					$.gc();
					}
				
				if (fileArray.length > 1)
					alert (localize ("$$$/PSBI/Place/OnlyFirstFile=Only the first file was placed."));
				}
			else
				{
				for (index = 0; index < fileArray.length; ++index)
					{
					var file = fileArray[index];
					
					// Open as a Smart Object
					app.open (file, undefined, true);
					}
				}
			}
		}
	catch (error)
		{
		if (error.number != 8007) // Don't report user cancelled errors.
			alert (error);
		}
	}

//-----------------------------------------------------------------
// The code below inserts the Place in Photoshop menu item into the 
// place menu and sets up the onSelect routines for it.
//-----------------------------------------------------------------
if ((BridgeTalk.appName == "bridge") && (BridgeTalk.appVersion == photoshop10.versionInfo.bridgeTargetVersion))
	{
	// Use temp function to keep vars out of global namespace.
	photoshop10.tempFunction = function ()
		{
		// insert a new PDF Presentation menu item into the Place submenu.
		var placeMenuItem = MenuElement.create ("command",
												localize ("$$$/PSBI/Menu/Place/InPhotoshop=In Photoshop"),
												'at the end of submenu/Place',
												'PlaceInPhotoshop');
			
		placeMenuItem.onSelect = function ()
			{
			try
				{
				if ((app.document == undefined) || (app.document.visibleThumbnails.length <= 0))
					{
					Window.alert (localize ("$$$/PSBI/Automate/NoFiles=There are no files to process."));
					return;
					}
				
				// check selection length before asking for selections (better performance)
				if (app.document.selectionLength != 1) 
					{
					Window.alert (localize ("$$$/PSBI/Place/SelectOneFile=Please select a single file."));
					return;
					}

				var selections = app.document.selections;
					
				if (!selections[0].container)
					{
					// Make sure this can be run.
					var availabilityCheckOptions = new AvailabilityCheckOptions ();
					
					// customize the behavior
					availabilityCheckOptions.busyAction = AvailabilityCheckOptions.kBusyWarn;
					availabilityCheckOptions.warnBusyText = localize ("$$$/PSBI/Error/PSBusyWarnPlace=Photoshop %1 is currently busy with another task. Please finish that task in Photoshop, open the document you want to place into, and try again.", photoshop10.versionInfo.displayVersion);
					
					if (!photoshop10.correctPSIsAvailable (availabilityCheckOptions))
						return;
					
					var thumb = selections[0];
					app.acquirePhysicalFiles (Array (thumb));
					
					if (thumb.spec == undefined)
						{
						Window.alert (localize ("$$$/PSBI/Place/AliasNotResolved=The alias could not be resolved."));
						return;
						}
						
					
					var file = photoshop10.resolveFileIfAlias (thumb.spec);
					
					if (file != null)
						photoshop10.place (file, availabilityCheckOptions);
					else
						Window.alert (localize ("$$$/PSBI/Place/AliasNotResolved=The alias could not be resolved."));
					}
				else
					{
					if (app.document.selectionLength == 1)
						Window.alert (localize ("$$$/PSBI/Automate/FoldersNotAllowed=Folders cannot be used for this command."));
					else
						Window.alert (localize ("$$$/PSBI/Place/SelectOneFile=Please select a single file."));
					}
				}
			catch (error)
				{
				if (error.number != 8007) // Don't report user cancelled errors.
					alert (error);
				}
			}
		}
	
	photoshop10.tempFunction ();
	delete photoshop10.tempFunction;
	}
	

//=================================================================
// PDF Presentation
// Sets up Photoshop's PDF Presentation automation command to be
// accessed from the Bridge.
//=================================================================

//-----------------------------------------------------------------
// This routine takes an array of files. If called by Photoshop,
// it will invoke PDF Presentation with the files. If called by
// any other app, it will send a BridgeTalk message to Photoshop
// to invoke this routine with the same arguments.
//-----------------------------------------------------------------
photoshop10.pdfPresentation = function (/* Array */ files, availabilityCheckOptions)
	{
	try
		{
		// Make sure this can be run.
		if (availabilityCheckOptions == null)
			availabilityCheckOptions = new AvailabilityCheckOptions ();
		
		if (!photoshop10.correctPSIsAvailable (availabilityCheckOptions))
			return;
		
		if (BridgeTalk.appName != "photoshop")
			{
			// Bring Photoshop to the foreground.
			BridgeTalk.bringToFront (photoshop10.versionInfo.btTargetName);
			
			// Create a new BridgeTalk message for Photoshop to invoke
			// PDF Presentation with the selected files
			var btMessage = new BridgeTalk;
			btMessage.target = photoshop10.versionInfo.btTargetName;
			btMessage.body = "photoshop10.pdfPresentation (" + files.toSource () + ");";
			
			// Make sure we attempt to launch it.
			if (!BridgeTalk.isRunning (photoshop10.versionInfo.btTargetName))
				BridgeTalk.launch (photoshop10.versionInfo.btTargetName);
				
			btMessage.send();
			}
		else
			{
			photoshop10.runActionCommand ('PDFExport', files);
			}
		}
	catch (error)
		{
		if (error.number != 8007) // Don't report user cancelled errors.
			alert (error);
		}
	}


//-----------------------------------------------------------------
// This routine is called when the Bridge's PDF Presentation menu
// item is chosen.
//-----------------------------------------------------------------
photoshop10.pdfPresentationFromBridge = function ()
	{
	try
		{
		// Make sure this can be run.
		var availabilityCheckOptions = new AvailabilityCheckOptions ();
		
		if (!photoshop10.correctPSIsAvailable (availabilityCheckOptions))
			return;
		
		var files = photoshop10.getBridgeFileListForAutomateCommand (true, false);
		
		if (files.length != 0)
			photoshop10.pdfPresentation (files, availabilityCheckOptions);
		}
	catch (error)
		{
		if (error.number != 8007) // Don't report user cancelled errors.
			alert (error);
		}

	}


//-----------------------------------------------------------------
// The code below inserts the PDF Presentation menu item into the
// Bridge menus.
//-----------------------------------------------------------------
if ((BridgeTalk.appName == "bridge") && (BridgeTalk.appVersion == photoshop10.versionInfo.bridgeTargetVersion))
	{
	// Use temp function to keep vars out of global namespace.
	photoshop10.tempFunction = function ()
		{
		// Set up the info necessary for inserting this item into the Bridge's menus later.
		var menuItemInfo = new Object;
		menuItemInfo.text = localize ("$$$/PSBI/Menu/Automate/PDFPres=PDF Presentation...");
		menuItemInfo.name = 'PdfPresentation';
		menuItemInfo.onSelect = photoshop10.pdfPresentationFromBridge;
		
		photoshop10.menuItemInfoArray.push (menuItemInfo);
		}
	
	photoshop10.tempFunction ();
	delete photoshop10.tempFunction;
	}

//=================================================================
// Photomerge
// Sets up Photoshop's Photomerge automation command to be
// accessed from the Bridge.
//=================================================================

//-----------------------------------------------------------------
// This routine takes an array of files. If called by Photoshop,
// it will invoke Photomerge with the files. If called by
// any other app, it will send a BridgeTalk message to Photoshop
// to invoke this routine with the same arguments.
//-----------------------------------------------------------------
photoshop10.photomerge = function (/* Array */ files, availabilityCheckOptions)
	{
	try
		{
		// Make sure this can be run.
		if (availabilityCheckOptions == null)
			availabilityCheckOptions = new AvailabilityCheckOptions ();
		
		if (!photoshop10.correctPSIsAvailable (availabilityCheckOptions))
			return;
		
		if (BridgeTalk.appName != "photoshop")
			{
			// Bring Photoshop to the foreground.
			BridgeTalk.bringToFront (photoshop10.versionInfo.btTargetName);
			
			// Create a new BridgeTalk message for Photoshop to invoke
			// Photomerge with the selected files
			var btMessage = new BridgeTalk;
			btMessage.target = photoshop10.versionInfo.btTargetName;
			btMessage.body = "photoshop10.photomerge (" + files.toSource () + ");";
			
			// Make sure we attempt to launch it.
			if (!BridgeTalk.isRunning (photoshop10.versionInfo.btTargetName))
				BridgeTalk.launch (photoshop10.versionInfo.btTargetName);
				
			btMessage.send ();
			}
		else
			{
			var gFilesFromBridge = files;

			var strPresets = localize ("$$$/ApplicationPresetsFolder/Presets=Presets");
			var strScripts = localize ("$$$/PSBI/Automate/ImageProcessor/Photoshop/Scripts=Scripts");
			var strPhotomerge = localize ("$$$/PSBI/Automate/Photomerge/Photoshop/FileName=Photomerge.jsx");
			var ipFilePath = app.path + "/" + strPresets + "/" + strScripts + "/" + strPhotomerge;

			var ipFile = new File (ipFilePath);

			var rememberDialogModes = displayDialogs;
			displayDialogs = DialogModes.ALL;
					
			if (ipFile.exists)
				{
				$.evalFile( ipFilePath );
				}
			else
				alert (localize ("$$$/PSBI/Automate/Photomerge/NotFound=%1 could not be found.", strMerge2HDR));
	
			displayDialogs = rememberDialogModes;
			}
		}
	catch (error)
		{
		if (error.number != 8007) // Don't report user cancelled errors.
			alert (error);
		}

	}


//-----------------------------------------------------------------
// This routine is called when the Bridge's Photomerge menu item is
// chosen.
//-----------------------------------------------------------------
photoshop10.photomergeFromBridge = function ()
	{
	try
		{
		// Make sure this can be run.
		var availabilityCheckOptions = new AvailabilityCheckOptions ();
		
		if (!photoshop10.correctPSIsAvailable (availabilityCheckOptions))
			return;
		
		var files = photoshop10.getBridgeFileListForAutomateCommand (true, true);
		
		if (files.length != 0)
			photoshop10.photomerge (files, availabilityCheckOptions);
		}
	catch (error)
		{
		if (error.number != 8007) // Don't report user cancelled errors.
			alert (error);
		}
	}


//-----------------------------------------------------------------
// The code below inserts the Photomerge menu item into the 
// Bridge menus.
//-----------------------------------------------------------------
if ((BridgeTalk.appName == "bridge") && (BridgeTalk.appVersion == photoshop10.versionInfo.bridgeTargetVersion))
	{	
	// Use temp function to keep vars out of global namespace.
	photoshop10.tempFunction = function ()
		{
		// Set up the info necessary for inserting this item into the Bridge's menus later.
		var menuItemInfo = new Object;
		menuItemInfo.text = localize ("$$$/PSBI/Menu/Automate/Photomerge=Photomerge...");
		menuItemInfo.name = 'Photomerge';
		menuItemInfo.onSelect = photoshop10.photomergeFromBridge;
		
		photoshop10.menuItemInfoArray.push (menuItemInfo);
		}
	
	photoshop10.tempFunction ();
	delete photoshop10.tempFunction;
	}


//=================================================================
// Contact Sheet
// Sets up Photoshop's Contact Sheet automation command to be
// accessed from the Bridge.
//=================================================================

//-----------------------------------------------------------------
// This routine takes an array of files. If called by Photoshop,
// it will invoke Contact Sheet with the files. If called by
// any other app, it will send a BridgeTalk message to Photoshop
// to invoke this routine with the same arguments.
//-----------------------------------------------------------------
photoshop10.contactSheet = function (/* Array */ files, availabilityCheckOptions)
	{
	try
		{
		// Make sure this can be run.
		if (availabilityCheckOptions == null)
			availabilityCheckOptions = new AvailabilityCheckOptions ();
		
		if (!photoshop10.correctPSIsAvailable (availabilityCheckOptions))
			return;
		
		if (BridgeTalk.appName != "photoshop")
			{
			// Bring Photoshop to the foreground.
			BridgeTalk.bringToFront (photoshop10.versionInfo.btTargetName);
			
			// Create a new BridgeTalk message for Photoshop to invoke
			// Contact Sheet with the selected files
			var btMessage = new BridgeTalk;
			btMessage.target = photoshop10.versionInfo.btTargetName;
			btMessage.body = "photoshop10.contactSheet (" + files.toSource () + ");";
			
			// Make sure we attempt to launch it.
			if (!BridgeTalk.isRunning (photoshop10.versionInfo.btTargetName))
				BridgeTalk.launch (photoshop10.versionInfo.btTargetName);
				
			btMessage.send ();
			}
		else
			{
			photoshop10.runActionCommand ('0B71D221-F8CE-11d2-B21B-0008C75B322C', files);
			}
		}
	catch (error)
		{
		if (error.number != 8007) // Don't report user cancelled errors.
			alert (error);
		}
	}


//-----------------------------------------------------------------
// This routine is called when the Bridge's Contact Sheet menu item
// is chosen.
//-----------------------------------------------------------------
photoshop10.contactSheetFromBridge = function ()
	{
	try
		{
		// Make sure this can be run.
		var availabilityCheckOptions = new AvailabilityCheckOptions ();
		
		if (!photoshop10.correctPSIsAvailable (availabilityCheckOptions))
			return;
		
		var files = photoshop10.getBridgeFileListForAutomateCommand (true, false);
		
		if (files.length != 0)
			photoshop10.contactSheet (files, availabilityCheckOptions);
		}
	catch (error)
		{
		if (error.number != 8007) // Don't report user cancelled errors.
			alert (error);
		}
	}


//-----------------------------------------------------------------
// The code below inserts the Contact Sheet menu item into the
// Bridge menus.
//-----------------------------------------------------------------
if ((BridgeTalk.appName == "bridge") && (BridgeTalk.appVersion == photoshop10.versionInfo.bridgeTargetVersion))
	{	
	// Use temp function to keep vars out of global namespace.
	photoshop10.tempFunction = function ()
		{
		// Set up the info necessary for inserting this item into the Bridge's menus later.
		var menuItemInfo = new Object;
		menuItemInfo.text = localize ("$$$/PSBI/Menu/Automate/ContactSheet=Contact Sheet II...");
		menuItemInfo.name = 'ContactSheet';
		menuItemInfo.onSelect = photoshop10.contactSheetFromBridge;
		
		photoshop10.menuItemInfoArray.push (menuItemInfo);
		}
	
	photoshop10.tempFunction ();
	delete photoshop10.tempFunction;
	}

//=================================================================
// Picture Package
// Sets up Photoshop's Picture Package automation command to be
// accessed from the Bridge.
//=================================================================

//-----------------------------------------------------------------
// This routine takes an array of files. If called by Photoshop,
// it will invoke Picture Package with the files. If called by
// any other app, it will send a BridgeTalk message to Photoshop
// to invoke this routine with the same arguments.
//-----------------------------------------------------------------
photoshop10.picturePackage = function (/* Array */ files, availabilityCheckOptions)
	{
	try
		{
		// Make sure this can be run.
		if (availabilityCheckOptions == null)
			availabilityCheckOptions = new AvailabilityCheckOptions ();
		
		if (!photoshop10.correctPSIsAvailable (availabilityCheckOptions))
			return;
		
		if (BridgeTalk.appName != "photoshop")
			{
			// Bring Photoshop to the foreground.
			BridgeTalk.bringToFront (photoshop10.versionInfo.btTargetName);
			
			// Create a new BridgeTalk message for Photoshop to invoke
			// Picture Package with the selected files
			var btMessage = new BridgeTalk;
			btMessage.target = photoshop10.versionInfo.btTargetName;
			btMessage.body = "photoshop10.picturePackage (" + files.toSource () + ");";
			
			// Make sure we attempt to launch it.
			if (!BridgeTalk.isRunning (photoshop10.versionInfo.btTargetName))
				BridgeTalk.launch (photoshop10.versionInfo.btTargetName);
				
			btMessage.send ();
			}
		else
			{
			photoshop10.runActionCommand ('4C1ABF40-DD82-11d2-B20F-0008C75B322C', files);
			}
		}
	catch (error)
		{
		if (error.number != 8007) // Don't report user cancelled errors.
			alert (error);
		}
	}


//-----------------------------------------------------------------
// This routine is called when the Bridge's Picture Package menu
// item is chosen.
//-----------------------------------------------------------------
photoshop10.picturePackageFromBridge = function ()
	{
	try
		{
		// Make sure this can be run.
		var availabilityCheckOptions = new AvailabilityCheckOptions ();
		
		if (!photoshop10.correctPSIsAvailable (availabilityCheckOptions))
			return;
		
		var files = photoshop10.getBridgeFileListForAutomateCommand (true, false);
		
		if (files.length != 0)
			photoshop10.picturePackage (files, availabilityCheckOptions);
		}
	catch (error)
		{
		if (error.number != 8007) // Don't report user cancelled errors.
			alert (error);
		}
	}


//-----------------------------------------------------------------
// The code below inserts the PicturePackage menu item into the
// Bridge menus.
//-----------------------------------------------------------------
if ((BridgeTalk.appName == "bridge") && (BridgeTalk.appVersion == photoshop10.versionInfo.bridgeTargetVersion))
	{
	// Use temp function to keep vars out of global namespace.
	photoshop10.tempFunction = function ()
		{
		// Set up the info necessary for inserting this item into the Bridge's menus later.
		var menuItemInfo = new Object;
		menuItemInfo.text = localize ("$$$/PSBI/Menu/Automate/PicturePackage=Picture Package...");
		menuItemInfo.name = 'PicturePackage';
		menuItemInfo.onSelect = photoshop10.picturePackageFromBridge;
		
		photoshop10.menuItemInfoArray.push (menuItemInfo);
		
		}
	
	photoshop10.tempFunction ();
	delete photoshop10.tempFunction;
	}


//=================================================================
// Batch
// Sets up Photoshop's Batch automation command to be
// accessed from the Bridge.
//=================================================================

//-----------------------------------------------------------------
// This routine takes an array of files. If called by Photoshop,
// it will invoke Batch with the files. If called by
// any other app, it will send a BridgeTalk message to Photoshop
// to invoke this routine with the same arguments.
//-----------------------------------------------------------------
photoshop10.batch = function (/* Array */ files, availabilityCheckOptions)
	{
	try
		{
		if (availabilityCheckOptions == null)
			availabilityCheckOptions = new AvailabilityCheckOptions ();
		
		// Make sure this can be run.
		if (!photoshop10.correctPSIsAvailable (availabilityCheckOptions))
			return;
		
		if (BridgeTalk.appName != "photoshop")
			{
			// Bring Photoshop to the foreground.
			BridgeTalk.bringToFront (photoshop10.versionInfo.btTargetName);
			
			// Create a new BridgeTalk message for Photoshop to invoke
			// Batch with the selected files
			var btMessage = new BridgeTalk;
			btMessage.target = photoshop10.versionInfo.btTargetName;
			btMessage.body = "photoshop10.batch (" + files.toSource () + ");";
			
			// Make sure we attempt to launch it.
			if (!BridgeTalk.isRunning (photoshop10.versionInfo.btTargetName))
				BridgeTalk.launch (photoshop10.versionInfo.btTargetName);
				
			btMessage.send ();
			}
		else
			{
			photoshop10.runActionCommand ('batch', files,
					localize ("$$$/PSBI/Automate/BatchSettingsFile=Batch via Bridge Settings"));
			}
		}
	catch (error)
		{
		if (error.number != 8007) // Don't report user cancelled errors.
			alert (error);
		}
	}


//-----------------------------------------------------------------
// This routine is called when the Bridge's Batch menu item is
// chosen.
//-----------------------------------------------------------------
photoshop10.batchFromBridge = function ()
	{
	try
		{
		var availabilityCheckOptions = new AvailabilityCheckOptions ();
		
		// Make sure this can be run.
		if (!photoshop10.correctPSIsAvailable (availabilityCheckOptions))
			return;
		
		var files = photoshop10.getBridgeFileListForAutomateCommand (true, false);
		
		if (files.length != 0)
			photoshop10.batch (files, availabilityCheckOptions);
		}
	catch (error)
		{
		if (error.number != 8007) // Don't report user cancelled errors.
			alert (error);
		}
	}


//-----------------------------------------------------------------
// The code below inserts the Batch menu item into the Bridge menus.
//-----------------------------------------------------------------
if ((BridgeTalk.appName == "bridge") && (BridgeTalk.appVersion == photoshop10.versionInfo.bridgeTargetVersion))
	{	
	// Use temp function to keep vars out of global namespace.
	photoshop10.tempFunction = function ()
		{
		// Set up the info necessary for inserting this item into the Bridge's menus later.
		var menuItemInfo = new Object;
		menuItemInfo.text = localize ("$$$/PSBI/Menu/Automate/Batch=Batch...");
		menuItemInfo.name = 'Batch';
		menuItemInfo.onSelect = photoshop10.batchFromBridge;
		
		photoshop10.menuItemInfoArray.push (menuItemInfo);
		}
	
	photoshop10.tempFunction ();
	delete photoshop10.tempFunction;
	}


//=================================================================
// Web Photo Gallery
// Sets up Photoshop's Web Photo Gallery automation command to be
// accessed from the Bridge.
//=================================================================

//-----------------------------------------------------------------
// This routine takes an array of files. If called by Photoshop,
// it will invoke Web Photo Gallery with the files. If called by
// any other app, it will send a BridgeTalk message to Photoshop
// to invoke this routine with the same arguments.
//-----------------------------------------------------------------
photoshop10.webPhotoGallery = function (files, availabilityCheckOptions)
	{
	try
		{
		// Make sure this can be run.
		if (availabilityCheckOptions == null)
			availabilityCheckOptions = new AvailabilityCheckOptions ();
			
		if (!photoshop10.correctPSIsAvailable (availabilityCheckOptions))
			return;
		
		if (BridgeTalk.appName != "photoshop")
			{
			// Bring Photoshop to the foreground.
			BridgeTalk.bringToFront (photoshop10.versionInfo.btTargetName);
			
			// Create a new BridgeTalk message for Photoshop to invoke
			// Web Photo Gallery with the selected files
			var btMessage = new BridgeTalk;
			btMessage.target = photoshop10.versionInfo.btTargetName;
			btMessage.body = "photoshop10.webPhotoGallery (" + files.toSource () + ");";
						
			// Make sure we attempt to launch it.
			if (!BridgeTalk.isRunning (photoshop10.versionInfo.btTargetName))
				BridgeTalk.launch (photoshop10.versionInfo.btTargetName);
			
			btMessage.send ();
			}
		else
			{
			photoshop10.runActionCommand ('4C1ABF41-DD82-11d2-B20F-0008C75B322C', files);
			}
		}
	catch (error)
		{
		if (error.number != 8007) // Don't report user cancelled errors.
			alert (error);
		}
	}


//-----------------------------------------------------------------
// This routine is called when the Bridge's Web Photo Gallery menu
// item is chosen.
//-----------------------------------------------------------------
photoshop10.webPhotoGalleryFromBridge = function ()
	{
	try
		{
		// Make sure this can be run.
		var availabilityCheckOptions = new AvailabilityCheckOptions ();
			
		if (!photoshop10.correctPSIsAvailable (availabilityCheckOptions))
			return;
		
		var files = photoshop10.getBridgeFileListForAutomateCommand (true, false);
		
		if (files.length != 0)
			photoshop10.webPhotoGallery (files, availabilityCheckOptions);
		}
	catch (error)
		{
		if (error.number != 8007) // Don't report user cancelled errors.
			alert (error);
		}
	}


//-----------------------------------------------------------------
// The code below inserts the Web Photo Gallery menu item into the
// Bridge menus.
//-----------------------------------------------------------------
if ((BridgeTalk.appName == "bridge") && (BridgeTalk.appVersion == photoshop10.versionInfo.bridgeTargetVersion))
	{	
	// Use temp function to keep vars out of global namespace.
	photoshop10.tempFunction = function ()
		{
		// Set up the info necessary for inserting this item into the Bridge's menus later.
		var menuItemInfo = new Object;
		menuItemInfo.text = localize ("$$$/PSBI/Menu/Automate/WPG=Web Photo Gallery...");
		menuItemInfo.name = 'WebPhotoGallery';
		menuItemInfo.onSelect = photoshop10.webPhotoGalleryFromBridge;
		
		photoshop10.menuItemInfoArray.push (menuItemInfo);
		}
	
	photoshop10.tempFunction ();
	delete photoshop10.tempFunction;
	}



//=================================================================
// MergeToHDR
// Sets up Photoshop's MergeToHDR JavaScript to be
// accessed from the Bridge.
//=================================================================

//-----------------------------------------------------------------
// This routine takes an array of files. If called by Photoshop,
// it will invoke MergeToHDR with the files. If called by
// any other app, it will send a BridgeTalk message to Photoshop
// to invoke this routine with the same arguments.
//-----------------------------------------------------------------
photoshop10.mergeToHDR = function (files, availabilityCheckOptions)
	{
	try
		{
		// Make sure this can be run.
		if (availabilityCheckOptions == null)
			availabilityCheckOptions = new AvailabilityCheckOptions ();
			
		if (!photoshop10.correctPSIsAvailable (availabilityCheckOptions))
			return;
		
		if (BridgeTalk.appName != "photoshop")
			{
			// Bring Photoshop to the foreground.
			BridgeTalk.bringToFront (photoshop10.versionInfo.btTargetName);
	
			// Create a new BridgeTalk message for Photoshop to invoke
			// MergeToHDR with the selected files
			var btMessage = new BridgeTalk;
			btMessage.target = photoshop10.versionInfo.btTargetName;
			btMessage.body = "photoshop10.mergeToHDR (" + files.toSource () + ");";
			
			// Make sure we attempt to launch it.
			if (!BridgeTalk.isRunning (photoshop10.versionInfo.btTargetName))
				BridgeTalk.launch (photoshop10.versionInfo.btTargetName);
				
			btMessage.send ();
			}
		else
			{
	
			// Merge to HDR script will recognize this and use it
			var gFilesFromBridge = files;
	
			var strPresets = localize ("$$$/ApplicationPresetsFolder/Presets=Presets");
			var strScripts = localize ("$$$/PSBI/Automate/ImageProcessor/Photoshop/Scripts=Scripts");
			var strMerge2HDR = localize ("$$$/PSBI/Automate/MergeToHDR/Photoshop/FileName=Merge To HDR.jsx");
			var ipFilePath = app.path + "/" + strPresets + "/" + strScripts + "/" + strMerge2HDR;
			
			var ipFile = new File (ipFilePath);
			
			var rememberDialogModes = displayDialogs;
			displayDialogs = DialogModes.ALL;
					
			if (ipFile.exists)
				{
				$.evalFile( ipFilePath );
//				alert (localize ("$$$/PSBI/Automate/MergeToHDR/CouldNotOpen=%1 could not be opened.", strMerge2HDR));
				}
			else
				alert (localize ("$$$/PSBI/Automate/MergeToHDR/NotFound=%1 could not be found.", strMerge2HDR));
	
			displayDialogs = rememberDialogModes;
			}
		}
	catch (error)
		{
		if (error.number != 8007) // Don't report user cancelled errors.
			alert (error);
		}
	}


//-----------------------------------------------------------------
// This routine is called when the Bridge's mergeToHDR menu
// item is chosen.
//-----------------------------------------------------------------
photoshop10.mergeToHDRFromBridge = function ()
	{
	try
		{
		// Make sure this can be run.
		var availabilityCheckOptions = new AvailabilityCheckOptions ();
			
		if (!photoshop10.correctPSIsAvailable (availabilityCheckOptions))
			return;
		
		var files = photoshop10.getBridgeFileListForAutomateCommand (true, false);
		
		if (files.length != 0)
			photoshop10.mergeToHDR (files, availabilityCheckOptions);
		}
	catch (error)
		{
		if (error.number != 8007) // Don't report user cancelled errors.
			alert (error);
		}
	}


//-----------------------------------------------------------------
// The code below inserts the Merge to HDR menu item into the
// Bridge menus.
//-----------------------------------------------------------------
if ((BridgeTalk.appName == "bridge") && (BridgeTalk.appVersion == photoshop10.versionInfo.bridgeTargetVersion))
	{	
	// Use temp function to keep vars out of global namespace.
	photoshop10.tempFunction = function ()
		{
		// Set up the info necessary for inserting this item into the Bridge's menus later.
		var menuItemInfo = new Object;
		menuItemInfo.text = localize ("$$$/PSBI/Menu/Automate/MergeToHDR=Merge to HDR...");
		menuItemInfo.name = 'MergeToHDR';
		menuItemInfo.onSelect = photoshop10.mergeToHDRFromBridge;
		
		photoshop10.menuItemInfoArray.push (menuItemInfo);
		}
	
	photoshop10.tempFunction ();
	delete photoshop10.tempFunction;
	}


//=================================================================
// ImageProcessor
// Sets up Photoshop's Image Processor JavaScript to be
// accessed from the Bridge.
//=================================================================

//-----------------------------------------------------------------
// This routine takes an array of files. If called by Photoshop,
// it will invoke Image Processor with the files. If called by
// any other app, it will send a BridgeTalk message to Photoshop
// to invoke this routine with the same arguments.
//-----------------------------------------------------------------
photoshop10.imageprocessor = function (files, availabilityCheckOptions)
	{
	try
		{
		// Make sure this can be run.
		if (availabilityCheckOptions == null)
			availabilityCheckOptions = new AvailabilityCheckOptions ();
			
		if (!photoshop10.correctPSIsAvailable (availabilityCheckOptions))
			return;
		
		if (BridgeTalk.appName != "photoshop")
			{
			// Bring Photoshop to the foreground.
			BridgeTalk.bringToFront (photoshop10.versionInfo.btTargetName);
	
			// Create a new BridgeTalk message for Photoshop to invoke
			// Image Processor with the selected files
			var btMessage = new BridgeTalk;
			btMessage.target = photoshop10.versionInfo.btTargetName;
			btMessage.body = "photoshop10.imageprocessor (" + files.toSource () + ");";
			
			// Make sure we attempt to launch it.
			if (!BridgeTalk.isRunning (photoshop10.versionInfo.btTargetName))
				BridgeTalk.launch (photoshop10.versionInfo.btTargetName);
				
			btMessage.send ();
			}
		else
			{
	
			// Image Processor script will recognize this and use it
			var gFilesFromBridge = files;
	
			var strPresets = localize ("$$$/ApplicationPresetsFolder/Presets=Presets");
			var strScripts = localize ("$$$/PSBI/Automate/ImageProcessor/Photoshop/Scripts=Scripts");
			var strImageProcessor = localize ("$$$/PSBI/Automate/ImageProcessor/Photoshop/FileName=Image Processor.jsx");
			
			var ipFile = new File (app.path + "/" + strPresets + "/" + strScripts + "/" + strImageProcessor);
			
			var rememberDialogModes = displayDialogs;
			displayDialogs = DialogModes.ALL;
					
			if (ipFile.exists)
				{
				if (ipFile.open ('r'))
					{
					var script = ipFile.read ();
					ipFile.close ();
					eval (script);
					}
				else
					alert (localize ("$$$/PSBI/Automate/ImageProcessor/CouldNotOpen=Image Processor.jsx could not be opened."));
				}
			else
				alert (localize ("$$$/PSBI/Automate/ImageProcessor/NotFound=Image Processor.jsx could not be found."));
	
			displayDialogs = rememberDialogModes;
			}
		}
	catch (error)
		{
		if (error.number != 8007) // Don't report user cancelled errors.
			alert (error);
		}
	}


//-----------------------------------------------------------------
// This routine is called when the Bridge's Image Processor menu
// item is chosen.
//-----------------------------------------------------------------
photoshop10.imageprocessorFromBridge = function ()
	{
	try
		{
		// Make sure this can be run.
		var availabilityCheckOptions = new AvailabilityCheckOptions ();
			
		if (!photoshop10.correctPSIsAvailable (availabilityCheckOptions))
			return;
		
		var files = photoshop10.getBridgeFileListForAutomateCommand (true, false);
		
		if (files.length != 0)
			photoshop10.imageprocessor (files, availabilityCheckOptions);
		}
	catch (error)
		{
		if (error.number != 8007) // Don't report user cancelled errors.
			alert (error);
		}
	}


//-----------------------------------------------------------------
// The code below inserts the Image Processor menu item into the
// Bridge menus.
//-----------------------------------------------------------------
if ((BridgeTalk.appName == "bridge") && (BridgeTalk.appVersion == photoshop10.versionInfo.bridgeTargetVersion))
	{	
	// Use temp function to keep vars out of global namespace.
	photoshop10.tempFunction = function ()
		{
		// Set up the info necessary for inserting this item into the Bridge's menus later.
		var menuItemInfo = new Object;
		menuItemInfo.text = localize ("$$$/PSBI/Menu/Automate/ImageProcessor=Image Processor...");
		menuItemInfo.name = 'ImageProcessor';
		menuItemInfo.onSelect = photoshop10.imageprocessorFromBridge;
		
		photoshop10.menuItemInfoArray.push (menuItemInfo);
		}
	
	photoshop10.tempFunction ();
	delete photoshop10.tempFunction;
	}

//=================================================================
// Setup Tools > Photoshop menu in Bridge.
// Creates the menu, then sorts all the menu items we want to
// create before actually adding them to the menu.
//=================================================================

if ((BridgeTalk.appName == "bridge") && (BridgeTalk.appVersion == photoshop10.versionInfo.bridgeTargetVersion))
	{
	
	// Use temp function to keep vars out of global namespace.
	photoshop10.tempFunction = function ()
		{
		// The 'Photoshop Services' menu is installed by OLS, the 'Photoshop' menu
		// in installed either by this script, or by the Workflow Automation Scripts
		// (AdobeLibrary1.jsx) which also install menus for other apps. To get the
		// menus in the correct order, all three scripts cooperate - so make sure
		// you are aware of what's happening before changing this code.
		var psServicesMenuExists = MenuElement.find ('Tools/PhotoshopServices') != null;
		
		// Add a new Photoshop submenu in the Bridge's Tools menu.
		photoshopSubMenu = MenuElement.create (	"menu",
												localize ("$$$/PhotoshopJSX/Menu/Photoshop=Photoshop"),
												psServicesMenuExists ? "-after Tools/PhotoshopServices" : '-after submenu/VersionCue',
												'tools/ps');
			
		
		// Define a function that will sort the menu items for us.
		function menuTextOrder (a, b)
			{
			// Pass 'a' into 'b' to get reverse sort order so that they can be
			// added at the top of the menu and still be in alphabetical order
			// (the WAS scripts install additional menu items that end up below
			// these).
			return b.text.toLocaleLowerCase ().localeCompare (a.text.toLocaleLowerCase ());
			}
		
		// Sort the menu items
		photoshop10.menuItemInfoArray.sort (menuTextOrder);
		
		// Add the menu items to the Photoshop menu.
		for (var index = 0; index < photoshop10.menuItemInfoArray.length; index++)
			{
			var menuItemInfo = photoshop10.menuItemInfoArray[index];

			var menuItem = MenuElement.create (	'command',
												menuItemInfo.text,
												'at the beginning of tools/ps',
												menuItemInfo.name);
			
			menuItem.onSelect = menuItemInfo.onSelect;	
			}
		
		delete photoshop10.menuItemInfoArray;
		}
		
	photoshop10.tempFunction ();
	delete photoshop10.tempFunction;
	}


//-----------------------------------------------------------------
// Launch the Device Central application from the New Image dialog
// in Photoshop. The Device Central application allows the user to
// create a new Photoshop document for a specific device.
// Returns "true" if the send() command succeeds, false otherwise.
//-----------------------------------------------------------------

photoshop10.launchDeviceCentral = function (doNewDocument)
	{
	var result = false;
	try
		{
		var bt = new BridgeTalk;
	
		var dcTarget = "devicecentral";
	
		if (BridgeTalk.getSpecifier (dcTarget) == null)
			{
			result = false;
			}
		else
			{
			bt.target = dcTarget;
			if (doNewDocument)
				{
				bt.body = "app.activate(); app.newDocument();";
				}
			else
				{
				bt.body = "app.activate(); app.browse();"
				}

			// Make sure we attempt to launch it.
			if (!BridgeTalk.isRunning (dcTarget))
				BridgeTalk.launch (dcTarget);
				
			result = bt.send();
		
			result = true;		// I don't trust the return value from send ()
			}
		}
	catch (e)
		{
		result = false;
		}
	
	return result;
	}



// ================================================================
// ================================================================
// ================================================================
// Utility Routines
// ================================================================
// ================================================================
// ================================================================
	

//-----------------------------------------------------------------
// This routine takes an array of thumbnails and returns an array of the
// files represented by those thumbnail objects.
//-----------------------------------------------------------------
photoshop10.thumbnailArrayToFileArray = function (/* array of thumbnails */ thumbnails, resolveAliases, requireTwoFiles)
	{
	var thumbsArray = new Array ();
	var filesArray = new Array ();
	
	var foundFolder = false;
	
	for (var index = 0; index < thumbnails.length; index++ )
		{
		// Don't add containers to the list, but note if any were found.
		if (thumbnails[index].container)
			foundFolder = true;
		else
			thumbsArray.push (thumbnails[index]);
		}
	
	if (thumbsArray.length == 0)
		{
		if (foundFolder)
			Window.alert (localize ("$$$/PSBI/Automate/FoldersNotAllowed=Folders cannot be used for this command."));
		else
			Window.alert (localize ("$$$/PSBI/Automate/NoFiles=There are no files to process."));
		}
	else if (requireTwoFiles && (thumbsArray.length == 1))
		{
		Window.alert (localize ("$$$/PSBI/Automate/MoreThanOneRequired=This command requires two or more files."));
		}
	else
		{
		// We have adequate files, now acquire them (make sure VC files have
		// a local replica) and then grab the file specs.
		app.acquirePhysicalFiles (thumbsArray);
		
		var foundAlias = false;
		
		for (var index = 0; index < thumbsArray.length; index++ )
			{
			if (thumbsArray[index].spec != undefined)
				{
				var file = thumbsArray[index].spec;
				
				if (resolveAliases && file.alias)
					{
					foundAlias = true;
					
					file = photoshop10.resolveFileIfAlias (file);
					}
				
				if (file != null)
					filesArray.push (file);
				}
			}
	
		// The only way filesArray.length should be zero here is if an alias could not be resolved.
		// or acquire failed for some reason.
		if (filesArray.length == 0)
			Window.alert (localize ("$$$/PSBI/Automate/AliasNotResolved=The alias(es) could not be resolved and there are no other files to process."));
		}
		
	return filesArray;
	}

//-----------------------------------------------------------------
// This routine returns the selected files, or if no files are selected,
// all the files.
//-----------------------------------------------------------------
photoshop10.getBridgeFileListForAutomateCommand = function (resolveAliases, requireTwoFiles)
	{	
	var files = new Array;
	var warnNoFiles = false;
	
	if ((app.document != undefined) && (app.document.thumbnail != undefined))
		{
		if (app.document.selectionLength > 0)
			{
			files = photoshop10.thumbnailArrayToFileArray (app.document.selections, resolveAliases, requireTwoFiles);
			}
		else if (app.document.visibleThumbnails.length > 0)
			{
			files = photoshop10.thumbnailArrayToFileArray (app.document.visibleThumbnails, resolveAliases, requireTwoFiles);
			}
		else
			warnNoFiles = true;
		}
	else
		warnNoFiles = true;
	
	if (warnNoFiles)
		Window.alert (localize ("$$$/PSBI/Automate/NoFiles=There are no files to process."));
		
	return files;
	}
	
//-----------------------------------------------------------------
// This routine tries to return an array of File objects created
// from the 'files' argument. It will convert a single File object
// or a single string into an array of File objects, or it will
// convert an array of string and File objects into an array of
// file objects.
//-----------------------------------------------------------------
photoshop10.ExtractFileArray = function (files)
	{
	var fileArray = new Array;
	
	// If it isn't an array, make it a length one array.
	if (!(files instanceof Array))
		files = new Array (files);
	
	// Turn each item in the array into a File, or remove it.
	for (index = 0; index < files.length; ++index)
		{
		var file = files[index];
		
		if (file instanceof File)
			fileArray.push (file);
		else if (typeof file == 'string')
			fileArray.push (File (file));
		else
			{
			// do nothing
			}
		}
	
	return fileArray;
	}
	
//-----------------------------------------------------------------
// This routine executes the specified action. If 'settingsFileName'
// is provided, it uses any saved settings combined with the new
// file list, then saves the updated settings.
//-----------------------------------------------------------------
photoshop10.runActionCommand = function (eventString,
										files,
										settingsFileName)
	{
	var eventDesc = null;
	
	// Read in the old settings, if asked.
	if (settingsFileName != null)
		eventDesc = photoshop10.readDescriptor (settingsFileName);
	
	// If this is the first time we've run, there won't be a settings
	// file, so create a new blank descriptor.
	if (eventDesc == null)
		eventDesc = new ActionDescriptor ();
	
	if (files != null)
		{
		// Create an action list with the provided files and add them
		// to the descriptor, overriding any previous ones that might
		// have been there.
		var filesListKey = stringIDToTypeID ('filesList');
		var filesList = new ActionList ();
	
		for (var index = 0; index < files.length; index++)
			filesList.putPath (files[index]);
		
		eventDesc.putList (filesListKey, filesList);
		
		filesList = null; // garbage collect this below
		}
	
	// Force it to record.
	var forceRecordKey = stringIDToTypeID ('forceRecording');
	eventDesc.putBoolean (forceRecordKey, true);
	
	// Run the action.
	var eventKey = stringIDToTypeID (eventString);
	var resultDesc = executeAction (eventKey, eventDesc, DialogModes.ALL);
	
	// Don't record the action for Batch
	if (eventString == 'batch')
		resultDesc.erase (stringIDToTypeID ('using'));
	
	// Save the descriptor for next time, if asked.
	if (settingsFileName != null)
		photoshop10.saveDescriptor (settingsFileName, resultDesc);
	
	// force deletion of descriptor and list now
	eventDesc = null;
	$.gc();
	}
	
//-----------------------------------------------------------------
// This routine saves the given descriptor to a settings file using
// the given name.
//-----------------------------------------------------------------
photoshop10.saveDescriptor = function (name, descriptor)
	{
	// try-catch this routine so if something goes terribly wrong
	// we can still run the command.
	try
		{
		if ((descriptor == null) || (descriptor.count == 0))
			return;
			
		var folder = photoshop10.getActionCmdSettingsFolder ();
			
		if (!folder.exists && !folder.create ())
			return;
			
		var stream = descriptor.toStream ();
			
		var file = new File (folder.fsName + "/" + name + '.psp');
		
		if (file.open ('w'))
			{
			file.encoding = 'BINARY';
			file.write (stream);
			file.close ();
			}
		}
	catch (e)
		{
		return null;
		}
	}
	
//-----------------------------------------------------------------
// This routine retrieves a descriptor from a settings file using
// the given name. A descriptor ought to have been previously saved
// under the same name using saveDescriptor ().
//-----------------------------------------------------------------
photoshop10.readDescriptor = function (name)
	{
	// try-catch this routine so if something goes terribly wrong
	// we can still run the command.
	try
		{
		var folder = photoshop10.getActionCmdSettingsFolder ();
	
		var file = new File (folder.fsName + "/" + name + '.psp');
		
		if (!file.exists)
			return null;
			
		if (!file.open ('r'))
			return null;
			
		file.encoding = 'BINARY';
		var stream = file.read (file.length);
		file.close ();
		
		var descriptor = new ActionDescriptor ();
		descriptor.fromStream (stream);
		
		return descriptor;
		}
	catch (e)
		{
		return null;
		}
	}
	
//-----------------------------------------------------------------
// This routine retrieves a descriptor from a settings file using
// the given name. A descriptor ought to have been previously saved
// under the same name using saveDescriptor ().
//-----------------------------------------------------------------
photoshop10.getActionCmdSettingsFolder = function ()
	{
	var settingsFolder = new Folder (app.preferencesFolder);
	
	if (!settingsFolder.exists)
		settingsFolder.create ();
	
	return settingsFolder;
	}


//-----------------------------------------------------------------
// This routine creates and returns a BridgeTalk message that will
// invoke Bridge and tell it what to do based on the arguments. It
// is wrapped in a utility function because it is used by multiple
// other routines.
//-----------------------------------------------------------------
photoshop10.getInvokeBridgeMessage = function (newWindow, maximize, path)
	{
	var bt = new BridgeTalk;
	bt.target = photoshop10.versionInfo.bridgeTarget;
	
	// If there is no path, we want to pass nothing to Bridge's routines,
	// not an empty File object.
	var file = '';
	
	// toSource is our friend. The 'path' string may have quotes (single or double)
	// in it that start messing things up if we want to use it as part of a bigger
	// string (in particular part of a BridgeTalk message body); specifically, string
	// literals can get terminated early leading to syntax errors. So, we create
	// a File object out of it and call toSource on the File object to get back a
	// string that can be used as part of a larger string (nasty characters like
	// quotes will be replaced with URL friendly equivalents).
	if (path != null && path != '')
		file = File (path).toSource ();

	if (BridgeTalk.isRunning (photoshop10.versionInfo.bridgeTarget))
		{
		if (newWindow)
			{
			bt.body = "app.browseTo (" + file + ");";
			}
		else
			{
			bt.body = "if (app.documents.length == 0)"
					+ "		app.browseTo (" + file + ");"
					+ " else"
					+ "		{";
			
			// this conflicts with the maximize call when file is empty, so don't do it then
			if (file)
				bt.body +=  "app.document.thumbnail = new Thumbnail (" + file + ");";
				
			bt.body += "	app.document.bringToFront ();"
					 + "	}";
			}
		}
	else
		{
		// this conflicts with the maximize call when file is empty, so don't do it then
		if (file)
			bt.body = "app.document.thumbnail = new Thumbnail (" + file + ");";
		
		if ($.os.charAt (0) == 'W')
			{
			// On Windows, holding any key down when launching an app makes it
			// launch behind the current one. Since we support modifiers when
			// invoking bridge, this is problematic. To avoid this unwanted
			// behavior, we get Bridge to send a message back to Photoshop with
			// the body "BridgeTalk.bringToFront ('bridge')". If a key was held
			// down then Photoshp still has focus and the call will bring Bridge
			// to the foreground. If a key was not held down, then the call does
			// nothing.
			bt.body += "var bt = new BridgeTalk;"
					 + "bt.target = '" + photoshop10.versionInfo.btTargetName + "';"
					 + "bt.body = '" + 'BridgeTalk.bringToFront ("' + photoshop10.versionInfo.bridgeTarget + '")' + "';"
					 + "bt.send ();";
			}
		}
		
	if (maximize)
		bt.body += "app.document.maximize ();";
	
	return bt;
	}
	
//-----------------------------------------------------------------
// Returns true if the required version of Bridge is installed.
//-----------------------------------------------------------------

photoshop10.correctBridgeIsAvailable = function (showUI)
	{
	var result = false;
	
	if (BridgeTalk.isRunning (photoshop10.versionInfo.bridgeTarget))
		{
		// It's running, so it is definitely available!
		result = true;
		}
	else if (BridgeTalk.getSpecifier ('bridge', photoshop10.versionInfo.bridgeTargetVersion) == null)
		{
		if (showUI)
			alert (localize ("$$$/PSBI/Error/MatchingBridgeVersionNotInstalled=Adobe Bridge %1 is not installed or the installation is damaged. Please reinstall Bridge.", photoshop10.versionInfo.bridgeDisplayVersion));
			
		result = false;
		}
	else
		{
		// The target version is installed and should be launchable, unless a different version
		// is running, which we cannot reliable detect. Hope that is not the case.
		result = true;
		}
		
	return result;
	}


//-----------------------------------------------------------------
// Returns true if the required version of Photoshop is available
// to execute a command in the sense that it is installed and
// running or can be launched. It also indicates that it is
// ready to process a command (not busy) or that the user has
// requested that the command be queued even though Photoshop is
// busy.
//-----------------------------------------------------------------

photoshop10.correctPSIsAvailable = function (checkOptions)
	{
	// If no options are passed in, use default ones.
	if (checkOptions == null)
		{
		checkOptions = new AvailabilityCheckOptions ();
		}
	else
		{
		if (checkOptions.alreadyUsed == true)
			return checkOptions.alreadyUsedReturnValue;
		}
	
	var result = false;
		
	// No need to check to see if the correct version is installed because if it
	// isn't installed then this script doesn't get loaded, except inside of the 
	// correct version of Photoshop if it really is installed (and its registration
	// with BridgeTalk is broken).
	
	if (BridgeTalk.appName == "photoshop")
		{
		if (BridgeTalk.appVersion == photoshop10.versionInfo.version)
			{
			// This script is running in the target version of PS.
			result = true;
			}
		else
			{
			// We are running inside a different version of PS than what is required. This really
			// shouldn't happen because this script shouldn't load in a version other than
			// the required version.
			if (checkOptions.warnIfUnavailable)
				alert (checkOptions.warnInsidePSText);
			}
		}
	else if (BridgeTalk.isRunning (photoshop10.versionInfo.btTargetName))
		{
		// Above is a quick test to see if it is running. If it is, it can be messaged if necessary.
		var status = BridgeTalk.ping (photoshop10.versionInfo.btTargetName, "STATUS");
		
		if (status != "IDLE")
			{
			if (checkOptions.busyAction == AvailabilityCheckOptions.kBusyWarn)
				{
				alert (checkOptions.warnBusyText);
				result = false;
				}
			else if (checkOptions.busyAction == AvailabilityCheckOptions.kBusyAsk)
				{
				result = confirm (checkOptions.askBusyText);
				}
			else if (checkOptions.busyAction == AvailabilityCheckOptions.kBusyAutoQueue)
				result = true;
			else	// AvailabilityCheckOptions.kBusyAutoCancel
				result = false;
			}
		else
			result = true;
		}
	else
		{
		// The target version is installed and should be launchable, unless a different version
		// is running, which we cannot reliable detect. Hope that is not the case.
		result = true;
		}
		
	checkOptions.alreadyUsed = true;
	checkOptions.alreadyUsedReturnValue = result;
	
	return result;
	}
	
//-----------------------------------------------------------------
// If file is an alias: returns file's target if file is
// successfully resolved and the target exists, otherwise null. If
// file is not an alias: returns file.
//-----------------------------------------------------------------

photoshop10.resolveFileIfAlias = function (file)
	{
	if (file.alias)
		{
		try
			{
			file = file.resolve ();
			}
		catch (e)
			{
			file = null;
			}
			
		// On Windows, a shorcut may get resolved even if the target file doesn't exist
		if ((file != null) && !file.exists)
			file = null;
		}
	
	return file;
	}


} // Overall try catch
catch (e)
{
	// Debugging
	//alert (e);
}
